#include "evt.h"

#include "decoder.h"

#include "LCM_DMA_SPI.h"

volatile uint8_t spi0_int_transfer_is_done_test = 0; // 0-Busy,1-Send Compelte,
volatile uint8_t spi1_int_transfer_is_done_test = 0; // 0-Busy,1-Send Compelte,

char FrameBuffer[DISPLAY_BUFFER_LEN];
char FrameBuffer_B[DISPLAY_BUFFER_LEN];

flash_info_t m_flash_info = {0, 0, false};

flush_bmp_info_t flush_bmp_info;

static evt_timer_t evt_timer_100ms;

static void spi0_transfer_cb(void *om_spi, drv_event_t event, void *rx_buf, void *rx_cnt)
{
	if (event == DRV_EVENT_COMMON_DMA2PERIPH_COMPLETED)
	{
		spi0_int_transfer_is_done_test = 1;
	}
}

// SPI1的DMA中断服务函数
static void spi1_transfer_cb(void *om_spi, drv_event_t event, void *rx_buf, void *rx_cnt)
{
	if (event == DRV_EVENT_COMMON_READ_COMPLETED) // 如果是DMA读完成事件
	{
		spi1_int_transfer_is_done_test = 1; // 中断标志置1
		
		if(flush_bmp_info.buf_num)
			evt_set(DECOMPRES_BMP_EVT); // 设置解压图片数据事件
	}
}

void lcd_spi_turn_on(char on_off) // true ---not turn off SPI
{
	static char on_off_flag = false;
	
	if (on_off == false)
	{
			on_off_flag = false;
	}
	else
	{
		if (on_off_flag == false)
		{
			on_off_flag = true;
			// spi open
		}
	}
}

//void lcm_back_light(back_light_state_t State)
//{
//    if (State == back_light_state_off)
//    {
//        drv_gpio_write(OM_GPIO0,BITMASK(LCD_LED_LINGT), GPIO_LEVEL_LOW);
//    }
//    else
//    {
//        drv_gpio_write(OM_GPIO0,BITMASK(LCD_LED_LINGT), GPIO_LEVEL_HIGH);
//    }
//}

void spi_normal_lcd_write_reg(OM_SPI_Type *SPIx, char CSx, uint8_t reg, uint8_t *txbuf, int nByte)
{
	uint8_t rxbuf[1];

	lcd_spi_turn_on(true);

	drv_gpio_write(OM_GPIO0, BITMASK(LCD_CMD_PIN), GPIO_LEVEL_LOW);

	drv_spi_transfer(OM_SPI0, &reg, 1, rxbuf, 1, 1000);

	drv_gpio_write(OM_GPIO0, BITMASK(LCD_CMD_PIN), GPIO_LEVEL_HIGH);

	drv_spi_transfer(OM_SPI0, txbuf, nByte, rxbuf, 1, 1000);
}

void spi_normal_lcd_write_mem_ex(OM_SPI_Type *SPIx, char CSx, uint8_t *txbuf, int nByte)
{
	uint8_t rxbuf[nByte];
	
	lcd_spi_turn_on(true);

	drv_spi_transfer_dma(OM_SPI0, txbuf, nByte, rxbuf, nByte);
	while (!spi0_int_transfer_is_done_test);
	spi0_int_transfer_is_done_test = 0;
}

void DoubleBuffer_lcd_write(OM_SPI_Type *SPIx, char CSx, uint8_t *txbuf, int nByte)
{
	uint8_t rxbuf[nByte];
	
	//lcd_spi_turn_on(true);

	drv_spi_transfer_dma(OM_SPI0, txbuf, nByte, rxbuf, nByte);
}

void SPI_3wire_8bit_serial_data_buf(char *da, uint32_t len)
{
	// spi_normal_lcd_write_mem_ex(OM_SPI0, 0, da, len);
	DoubleBuffer_lcd_write(OM_SPI0, 0, (uint8_t *)da, len);
}

void lcd_pixer_trans(char start_stop)
{
	uint8_t reg = 0x2c;

	uint8_t rxbuf[1];
	
	lcd_spi_turn_on(true);
	
	if (start_stop != 0)
	{
		// end of the write pixer data
		drv_gpio_write(OM_GPIO0, BITMASK(LCD_CMD_PIN), GPIO_LEVEL_LOW);

		drv_spi_transfer(OM_SPI0, &reg, 1, rxbuf, 1, 1000);

		drv_gpio_write(OM_GPIO0, BITMASK(LCD_CMD_PIN), GPIO_LEVEL_HIGH);
	}
	else
	{
		// start of the write pixer data
	}
}

void lcm_screen_address_set(uint32_t x1, uint32_t y1, uint32_t x2, uint32_t y2)
{
	// ALW EDDY WEN ADD IT
#define x0_OFFSET 0
#define y0_OFFSET 0 // 2
	
	uint8_t reg;
	uint8_t buf[4];
	uint8_t *const start = buf;
	uint8_t *p = buf;
	
	x1 += x0_OFFSET;
	x2 += x0_OFFSET;
	y1 += y0_OFFSET;
	y2 += y0_OFFSET;
	
	p = start;
	reg = 0x2a; // Column address set command in sf->COMMAND_DATA0_REG[0]
	*p++ = (x1 >> 8) & 0xFF;
	*p++ = (x1 >> 0) & 0xFF;
	*p++ = (x2 >> 8) & 0xFF;
	*p++ = (x2 >> 0) & 0xFF;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0x2b; // Row address set command in sf->COMMAND_DATA0_REG[0]
	*p++ = (y1 >> 8) & 0xFF;
	*p++ = (y1 >> 0) & 0xFF;
	*p++ = (y2 >> 8) & 0xFF;
	*p++ = (y2 >> 0) & 0xFF;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
}

void clear_Screen(uint16_t color)
{
	uint16_t i = 0;
	uint8_t buf[LINE_BYTES];

	for (i = 0; i < LINE_BYTES / 2; i ++)
	{
		buf[2 * i] = (uint8_t)(color >> 8);
		buf[2 * i + 1] = (uint8_t)color & 0xff;
	}
	lcm_screen_address_set(0, 0, LCD_FULLSCREEN_COLUMN - 1, LCD_FULLSCREEN_ROW - 1);
	lcd_pixer_trans(1);
	for (i = 0; i < LCD_FULLSCREEN_ROW; i += 10)
	{
		spi_normal_lcd_write_mem_ex(OM_SPI0, 0, buf, sizeof(buf));
	}
	lcd_pixer_trans(0);
}

// clear area
void lcd_fill_area(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1, uint16_t color)
{
	uint16_t i = 0;
	uint8_t buf[LINE_BYTES];

	for (i = 0; i < LINE_BYTES / 2; i ++)
	{
		buf[2 * i] = (uint8_t)(color >> 8);
		buf[2 * i + 1] = (uint8_t)color & 0xff;
	}
	lcm_screen_address_set(x0, y0, x1, y1);
	lcd_pixer_trans(1);

	for (i = y0; i < y1; i ++)
	{
		spi_normal_lcd_write_mem_ex(OM_SPI0, 0, buf, sizeof(buf));
	}
	lcd_pixer_trans(0);
}

static void lcm_config_init_240x240(void)
{
	uint8_t reg;
	uint8_t buf[15]; // [100];
	uint8_t *const start = buf;
	uint8_t *p = buf;
	
	lcd_spi_turn_on(true);
	
	drv_gpio_write(OM_GPIO0, BITMASK(LCD_RES_PIN), GPIO_LEVEL_HIGH);
	DRV_DELAY_MS(250);
	drv_gpio_write(OM_GPIO0, BITMASK(LCD_RES_PIN), GPIO_LEVEL_LOW);
	DRV_DELAY_MS(250);
	drv_gpio_write(OM_GPIO0, BITMASK(LCD_RES_PIN), GPIO_LEVEL_HIGH);
	DRV_DELAY_MS(250);
	
	p = start;
	reg = 0x11;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	DRV_DELAY_MS(250);
	
	p = start;
	reg = 0x36;
	*p++ = 0x00; // CONFIG_LCD_DIRECTION
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	//DRV_DELAY_MS(5);
	
	// p = start;
	// reg = 0xe7;
	// *p++ = 0x10;
	// spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0x3A;
	*p++ = 0x55; //
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xB2;
	*p++ = 0x0C;
	*p++ = 0x0C;
	*p++ = 0x00;
	*p++ = 0x33;
	*p++ = 0x33;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xB7;
	*p++ = 0x35;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xBB;
	*p++ = 0x32;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	// p = start;
	// reg = 0xC0;
	// *p++ = 0x2C;
	// spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xC2;
	*p++ = 0x01;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xC3;
	*p++ = 0x19;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xC4;
	*p++ = 0x20;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xC6;
	*p++ = 0x0F;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	// p = start;
	// reg = 0xd6;
	// *p++ = 0xa1;
	// spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xD0;
	*p++ = 0xA4;
	*p++ = 0xA1;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xE0;
	*p++ = 0xD0;
	*p++ = 0x08;
	*p++ = 0x0e;
	*p++ = 0x09;
	*p++ = 0x09;
	*p++ = 0x05;
	*p++ = 0x31;
	*p++ = 0x33;
	*p++ = 0x48;
	*p++ = 0x17;
	*p++ = 0x14;
	*p++ = 0x15;
	*p++ = 0x31;
	*p++ = 0x34;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0xE1;
	*p++ = 0xD0;
	*p++ = 0x08;
	*p++ = 0x0e;
	*p++ = 0x09;
	*p++ = 0x09;
	*p++ = 0x05;
	*p++ = 0x31;
	*p++ = 0x33;
	*p++ = 0x48;
	*p++ = 0x17;
	*p++ = 0x14;
	*p++ = 0x15;
	*p++ = 0x31;
	*p++ = 0x34;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	//  p = start;
	// reg = 0xE4;
	// *p++ = 0x1d;
	// *p++ = 0x00;
	// *p++ = 0x00;
	// spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
#if 1//(CONFIG_LCD_ST7789V2_IPS || CONFIG_LCD_ST7789T3_IPS)
	p = start;
	reg = 0x21;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
#endif

	p = start;
	reg = 0x2a;
	*p++ = 0x00;
	*p++ = 0x00;
	*p++ = 0x00;
	*p++ = 0xef;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0x2b;
	*p++ = 0x00;
	*p++ = 0x00;
	*p++ = 0x00;
	*p++ = 0xef;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	
	p = start;
	reg = 0x29;
	spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
}

void lcm_sleep_mode_control(uint8_t lcd_sleep)
{
	uint8_t reg;
	uint8_t buf[16];
	uint8_t *const start = buf;
	uint8_t *p = buf;
	
	if (lcd_sleep == true) // LCD enter in sleep
	{
		spi_normal_lcd_write_reg(OM_SPI0, 0, 0xfe, NULL, 0);
		spi_normal_lcd_write_reg(OM_SPI0, 0, 0xef, NULL, 0);
		// DISP   OFF
		spi_normal_lcd_write_reg(OM_SPI0, 0, 0x28, NULL, 0);
		DRV_DELAY_MS(120);
		// enter   SLEEP   MODE
		spi_normal_lcd_write_reg(OM_SPI0, 0, 0x10, NULL, 0);
		DRV_DELAY_MS(150);
		
		// p = start;
		// reg = 0xB1;
		// *p++ = 0x0c; //BUF[0]
		// spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
		
		// p = start;
		// reg = 0xa4;
		// *p++ = 0x04; //BUF[0]
		// spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
		
		// p = start;
		// reg = 0xe2;
		// *p++ = 0x04; //BUF[0]
		// spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
		
		// p = start;
		// reg = 0xe3;
		// *p++ = 0x00; //BUF[0]
		// *p++ = 0x0f; //BUF[1]
		// spi_normal_lcd_write_reg(OM_SPI0, 0, reg, start, p - start);
	}
	else if (lcd_sleep == false) // LCD exit out sleep
	{
		spi_normal_lcd_write_reg(OM_SPI0, 0, 0xfe, NULL, 0);
		spi_normal_lcd_write_reg(OM_SPI0, 0, 0xef, NULL, 0);
		// EXIT   SLEEP   MODE
		spi_normal_lcd_write_reg(OM_SPI0, 0, 0x11, NULL, 0);
		DRV_DELAY_MS(120);
		// IDSP   ON
		spi_normal_lcd_write_reg(OM_SPI0, 0, 0x29, NULL, 0);
		DRV_DELAY_MS(10);
		// EXIT   SLEEP   MODE,
		//spi_normal_lcd_write_reg(OM_SPI0, 0, 0x11, NULL, 0);
	}
}

void drv_spi_flash_init(void)
{
	spi_config_t	spi_cfg;
	
	spi_cfg.freq        = SPI_SPEED;
	spi_cfg.role        = SPI_ROLE_MASTER;
	spi_cfg.mode        = SPI_MODE_0;
	spi_cfg.wire        = SPI_WIRE_4;
	spi_cfg.first_bit   = SPI_MSB_FIRST;
	spi_cfg.cs_valid    = SPI_CS_LOW;
	
	drv_spi_init(OM_SPI0, &spi_cfg);
	drv_spi_dma_channel_allocate(OM_SPI0, SPI_DMA_TX_CHAN);
	drv_spi_register_isr_callback(OM_SPI0, spi0_transfer_cb);
	
	pm_sleep_prevent(PM_ID_SPI0);

	drv_spi_init(OM_SPI1, &spi_cfg);
	drv_spi_dma_channel_allocate(OM_SPI1, SPI_DMA_RX_CHAN);
	drv_spi_rx_dma_config(OM_SPI1);
	drv_spi_register_isr_callback(OM_SPI1, spi1_transfer_cb);
	register_set(&OM_SPI1->DELAY_SAMPLE, MASK_1REG(SPI_DELAY_SAMPLE_CYCLE_NUM, (uint32_t)1 /* argu = 1,2,3 */));
	
	pm_sleep_prevent(PM_ID_SPI1);
	
	lcm_sleep_mode_control(false);
}

void drv_spi_flash_uninit(void)
{
//	if (!m_flash_info.present)
//		return;

	drv_spi_dma_channel_release(OM_SPI0, SPI_DMA_TX_CHAN); // SPI_DMA_CHAN_ALL
	drv_spi_register_isr_callback(OM_SPI0, NULL);
	
	drv_spi_dma_channel_release(OM_SPI1, SPI_DMA_RX_CHAN); // SPI_DMA_CHAN_ALL
	drv_spi_register_isr_callback(OM_SPI1, NULL);
	
	pm_sleep_allow(PM_ID_SPI0);
	pm_sleep_allow(PM_ID_SPI1);
}

static void evt_timer_100ms_handler(evt_timer_t *timer, void *param)
{
	if(flush_bmp_info.bmp_num_add == flush_bmp_info.bmp_total_num - 1)
	{
		flush_bmp_info.bmp_num_add = 0;
		
		lcm_sleep_mode_control(true);
		
		drv_gpio_write(OM_GPIO0, BITMASK(LCD_LED_LINGT), GPIO_LEVEL_LOW); // LCM背光关闭
		
		drv_spi_flash_uninit();	
		
		evt_timer_del(&evt_timer_100ms);
		
		return ;
	}

	flush_bmp_info.bmp_num_add ++;
	
	gif_show();
}

// 刷屏图片地址偏移量信息表
uint32_t bmplist[] =
{
//	0x00000000, // fire_ 00.bmp
//	0x0000E532, // fire_ 01.bmp
//	0x0001CA64, // fire_ 02.bmp
//	0x0002AF96, // fire_ 03.bmp
//	0x000394C8, // fire_ 04.bmp
//	0x000479FA, // fire_ 05.bmp
//	0x00055F2C, // fire_ 06.bmp
//	0x0006445E, // fire_ 07.bmp
//	0x00072990, // fire_ 08.bmp
//	0x00080EC2, // fire_ 09.bmp
//	0x0008F3F4, // fire_ 10.bmp
//	//total size(KByte): 630.29
	
	0x00000000, // _8bit(58678)
	0x0000E536, // _8bit(58678)
	0x0001CA6C, // _8bit(58678)
	0x0002AFA2, // _8bit(58678)
	0x000394D8, // _8bit(58678)
	0x00047A0E, // _8bit(58678)
	0x00055F44, // _8bit(58678)
	0x0006447A, // _8bit(58678)
	0x000729B0, // _8bit(58678)
	0x00080EE6, // _8bit(58678)
	0x0008F41C, // _8bit(58678)
	0x0009D952, // _8bit(58678)
	0x000ABE88, // _8bit(58678)
	0x000BA3BE, // _8bit(58678)
	0x000C88F4, // _8bit(58678)
	0x000D6E2A, // _8bit(58678)
	0x000E5360, // _8bit(58678)
	0x000F3896, // _8bit(58678)
	0x00101DCC, // _8bit(58678)
	0x00110302, // _8bit(58678)
	0x0011E838, // _8bit(58678)
	0x0012CD6E, // _8bit(58678)
	0x0013B2A4, // _8bit(58678)
	0x001497DA, // _8bit(58678)
	0x00157D10, // _8bit(58678)
	0x00166246, // _8bit(58678)
	0x0017477C, // _8bit(58678)
	0x00182CB2, // _8bit(58678)
	0x001911E8, // _8bit(58678)
	0x0019F71E, // _8bit(58678)
	0x001ADC54, // _8bit(58678)
	0x001BC18A, // _8bit(58678)
	0x001CA6C0, // _8bit(58678)
	0x001D8BF6, // _8bit(58678)
	0x001E712C, // _8bit(58678)
	0x001F5662, // _8bit(58678)
	0x00203B98, // _8bit(58678)
	0x002120CE, // _8bit(58678)
	0x00220604, // _8bit(58678)
	0x0022EB3A, // _8bit(58678)
	0x0023D070, // _8bit(58678)
	0x0024B5A6, // _8bit(58678)
	0x00259ADC, // _8bit(58678)
	0x00268012, // _8bit(58678)
	0x00276548, // _8bit(58678)
	0x00284A7E, // _8bit(58678)
	0x00292FB4, // _8bit(58678)
	0x002A14EA, // _8bit(58678)
	0x002AFA20, // _8bit(58678)
	0x002BDF56, // _8bit(58678)
	0x002CC48C, // _8bit(58678)
	0x002DA9C2, // _8bit(58678)
	0x002E8EF8, // _8bit(58678)
	0x002F742E, // _8bit(58678)
	0x00305964, // _8bit(58678)
	0x00313E9A, // _8bit(58678)
	0x003223D0, // _8bit(58678)
	0x00330906, // _8bit(58678)
	0x0033EE3C, // _8bit(58678)
	0x0034D372, // _8bit(58678)
	0x0035B8A8, // _8bit(58678)
	// total size(KByte): 3,495.50
};

void gif_show(void)
{	
	evt_clear(FLUSH_LCM_EVT_START); // 清除刷屏开始事件
	
	pm_sleep_prevent(PM_ID_SPI0); // SPI0阻止睡眠
	pm_sleep_prevent(PM_ID_SPI1); // SPI1阻止睡眠
	
	fast_show_bmp_image(bmplist[flush_bmp_info.bmp_num_add] + bmplist[0]); // 开始刷屏

#if 0
	int i = 0;
	
	while (1)
	{
		for (i = 0; i < 11; i ++)
		{
			lcm_screen_address_set(0, 0, 239, 239);
			fast_show_bmp_image(bmplist[i] + 0x0000);//0x35000);
			DRV_DELAY_MS(50);
		}

		for (i = 0; i < 61; i ++)
		{
			lcm_screen_address_set(0, 0, 239, 239); // 设置刷屏区域
			fast_show_bmp_image(bmplist[flush_bmp_info.bmp_num_add] + bmplist[0]); // 开始刷屏
			DRV_DELAY_MS(127);
		}

		DRV_DELAY_MS(50);
		clear_Screen(_BLACK);
		DRV_DELAY_MS(50);
	}
#endif
}

void gif_show_enter(void)
{
	drv_spi_flash_init();
	
	flush_bmp_info.bmp_Flash_addr = 0;
	
	evt_timer_set(&evt_timer_100ms, 100, EVT_TIMER_REPEAT, evt_timer_100ms_handler, NULL); // 设置100ms间隔刷一张图的软定时器
	
	drv_gpio_write(OM_GPIO0, BITMASK(LCD_LED_LINGT), GPIO_LEVEL_HIGH); // LCM背光打开
	
	gif_show();
}

int8_t sf_read(uint32_t *flash_addr, uint32_t *ram_addr, uint32_t len, uint8_t wait)
{
//	if (!ram_addr) 
//	{
//		OM_LOG_DEBUG("error:read to ram addr = 0\n");
//		return -1;
//	}
//	if (!len) 
//	{
//		OM_LOG_DEBUG("error:read length = 0\n");
//		return -2;
//	}
//	if (flash_addr >= (1u << m_flash_info.cid)) 
//	{
//		OM_LOG_DEBUG("error:read address greater than flash capacity\n");
//		return -3;
//	}
//	if ((flash_addr + len) > (1u << m_flash_info.cid))
//	{
//		OM_LOG_DEBUG("error:read length greater than flash capacity\n");
//		return -4;
//	}
	
	OM_CRITICAL_BEGIN();
		
	SPI_CSN_LOW(OM_SPI1);

	register_set(&OM_SPI1->CTRL, MASK_2REG(SPI_CTRL_RX_FIFO_EN, 1, SPI_CTRL_TX_FIFO_EN, 1));

	// step 1: send cmd + address + dummy
	OM_SPI1->CTRL |= SPI_CTRL_TX_CLR_FIFO_MASK|SPI_CTRL_RX_CLR_FIFO_MASK;
	OM_SPI1->CTRL &= ~(SPI_CTRL_TX_CLR_FIFO_MASK|SPI_CTRL_RX_CLR_FIFO_MASK);

	OM_SPI1->DMACR = 0;
		
	OM_SPI1->WDATA = SPI_CMD_FAST_READ;
	OM_SPI1->WDATA = (*(uint32_t *)&flash_addr >> 16) & 0xFF;
	OM_SPI1->WDATA = (*(uint32_t *)&flash_addr >> 8) & 0xFF;
	OM_SPI1->WDATA = (*(uint32_t *)&flash_addr >> 0) & 0xFF;
	OM_SPI1->WDATA = 0;	
		
	while(5 != register_get(&OM_SPI1->STAT, MASK_POS(SPI_STAT_RX_BYTE_CNT)));

	OM_CRITICAL_END();

	OM_SPI1->CTRL |= SPI_CTRL_RX_CLR_FIFO_MASK;
	OM_SPI1->CTRL &= ~SPI_CTRL_RX_CLR_FIFO_MASK;

	// step 2: dma read
	spi1_int_transfer_is_done_test = 0;
	drv_spi_transfer_dma(OM_SPI1, (uint8_t *)ram_addr, len, (uint8_t *)ram_addr, len);
	
	if(wait == true)
	{
		while (!spi1_int_transfer_is_done_test);
		spi1_int_transfer_is_done_test = 0;
	}
	
	return 0;
}

void lcm_init(void)
{
	uint32_t id = 0;
	om_error_t error = OM_ERROR_FAIL;

	uint8_t read_id_cmd[4] = {SPI_CMD_RDID, 0, 0, 0};
	uint8_t read_id_rsp[4] = {0, 0, 0, 0};

	drv_spi_flash_init(); // 初始化刷屏和读flash的两组SPI，并且是使用DMA的单独写和单独读的功能。
	
	error = drv_spi_transfer(OM_SPI1, &read_id_cmd[0], sizeof(read_id_cmd), &read_id_rsp[0], sizeof(read_id_rsp), 1000); // 读flash的基本信息
	
	id = (id << 8) + read_id_rsp[1];
	id = (id << 8) + read_id_rsp[2];
	id = (id << 8) + read_id_rsp[3];	
	if(id == 0 || id == 0xFFFFFF) 
	{
		error = OM_ERROR_RESOURCES;
	}	
	m_flash_info.mid = read_id_rsp[1];
	m_flash_info.cid = read_id_rsp[3];
	m_flash_info.present = true;

//	__enable_irq(); // 如果不使用系统的时候注意要开总中断
	
	drv_gpio_write(OM_GPIO0, BITMASK(LCD_LED_LINGT), GPIO_LEVEL_LOW); // LCM背光关闭
	
	lcm_config_init_240x240(); // 初始化配置LCM，使其能正常显示
	
	flush_bmp_info.bmp_num_add = 0;
	
	flush_bmp_info.bmp_total_num = sizeof(bmplist) / sizeof(uint32_t);
	
	evt_callback_set(FLUSH_LCM_EVT_START, gif_show_enter); // 设置刷屏开始事件的回调函数
	evt_callback_set(DECOMPRES_BMP_EVT, decompres_bmp_evt_cb); // 设置解压图片数据事件的回调函数

	evt_set(FLUSH_LCM_EVT_START); // 设置刷屏开始的事件，激活刷屏
}
